﻿package
{
	import flash.media.Sound;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLRequest;
	
	public class AudioBank
	{
		// Declare vars here.
		private var name:Array;
		private var bank:Array;
		private var notifier:Function;
		private var snd:Sound;
		private var soundFile:String;
		
		// Constructor.
		public function AudioBank()
		{
			// Make empty arrays.
			name = new Array();
			bank = new Array();
			
			// There isn't a notifier yet.
			notifier = null;
			
			// No sound.
			snd = null;
		}  // End: Constructor

		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX      SETTERS AND GETTERS      XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

		public function set notify(f:Function):void
		// Purpose:  Sets a function to be called when the audio if finished loading.
		{
			notifier = f;
		}  // End: set notify(f:Function):void
		
		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX      FUNCTIONS     XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXX

		public function loadAudio(fName:String, fExtension:String = ""):void
		// Purpose:  Loads the audio and if successful, places it in the bank.
		{
			// Assume that this file will be successfully loaded.
			name.push(fName);
			
			soundFile = fName;
			
			// If there is an extension,
			if (fExtension != "")
			{
				// Add it to the file name.
				soundFile = soundFile + "." + fExtension;
			}
			// Create a new sound.
			snd = new Sound();
			
			// Set the sound event listeners.
			snd.addEventListener(IOErrorEvent.IO_ERROR, loadFailed, false, 0, true);
			snd.addEventListener(Event.COMPLETE, loadCompleted, false, 0, true);

			// Load the audio.  (In future, may need to set where audio is located.)
			snd.load(new URLRequest("audio/" + soundFile));
		}  // End: loadAudio(fName:String, fExtension:String = ""):void
		
		
		private function findAudio(fName:String):int
		// Purpose:  Locates and returns the index of where the requested audio is.
		{
			// For the length of bank,
			for (var i:int = 0; i < name.length; i++)
			{
				// If this is the file being looked for,
				if (name[i] == fName)
				{
					// Don't look further.
					return i;
				}
			}
			// The file is not here.
			return -1;
		}  // End: findAudio(fName:String):uint
		
		
		public function getAudio(fName:String):Sound
		// Purpose:  Gets the sound in the bank.
		{
			// Get the audio index.
			var index:int = findAudio(fName);
			
			// If there is a file,
			if (index != -1)
			{
				// Return the sound.
				return bank[index];
			}
			else
			{
				// Return nothing.
				return null;
			}
		}  // End: getAudio(fName:String):Sound
		
		
		private function loadFailed(evt:IOErrorEvent):void
		// Purpose:  Handles the failure to load an audio.
		{
			// Remove listeners.
			snd.removeEventListener(IOErrorEvent.IO_ERROR, loadFailed);
			snd.removeEventListener(Event.COMPLETE, loadCompleted);
			
			// File failed to load so remove it from the bank.
			name.pop();
			
			// Give the user some info if requested.
			if (true)
			{
				trace("The audio bank failed to load: " + soundFile);
			}
			// If there is a notifier,
			if (notifier != null)
			{
				// Notify it.
				notifier();
			}
		}  // End: loadFailed(evt:IOErrorEvent):void
		
		
		private function loadCompleted(evt:Event):void
		// Purpose:  Pushes the sound into the bank.
		{
			// Remove listeners.
			snd.removeEventListener(IOErrorEvent.IO_ERROR, loadFailed);
			snd.removeEventListener(Event.COMPLETE, loadCompleted);

			// Add the sound to the bank.
			bank.push(snd);
			
			// If there is a notifier,
			if (notifier != null)
			{
				// Notify it.
				notifier();
			}			
		}  // End: loadCompleted(evt:Event):void
		
	}  // End: AudioBank
}  // End: package