﻿package
{
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.media.SoundMixer;
	
	import fl.transitions.Tween;
	import fl.transitions.TweenEvent;
	import fl.transitions.easing.*;
	
	public class Popup extends MovieClip
	{
		private var sndFunc:Function;
		private var aClip:uint;
		private var xTween:Tween;
		private var yTween:Tween;
		
		
		// Constructor.
		public function Popup()
		{
			// Hide until ready.
			this.visible = false;
			
			// No sound function as yet.
			sndFunc = null;
			
			// Stop playing.
			gotoAndStop(1);
			
			// Hide the close button.
			btClose.visible = false;
			
			btClose.addEventListener(MouseEvent.CLICK, pressClose, false, 0, true);
		}   // End: Constructor.

		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX    SETTERS AND GETTERS    XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		

		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX         LISTENERS         XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		
		
		private function pressClose(evt:MouseEvent):void
		// Purpose:  Closes the popup.
		{
			// Hide the close button.
			btClose.visible = false;

			// Kill any audio playing.
			SoundMixer.stopAll();

			// Shrink the popup.
			xTween = new Tween(this, "scaleX", Regular.easeIn, 1.0, 0.01, 15);
			yTween = new Tween(this, "scaleY", Regular.easeIn, 1.0, 0.01, 15);
			
			xTween.addEventListener(TweenEvent.MOTION_FINISH, finishShrinking, false, 0, true);

		}  // End: pressClose(evt:MouseEvent):void
		
		
		private function finishGrowing(evt:TweenEvent):void
		// Purpose:  Plays the audio.
		{
			// Kill the tweens.
			xTween = null;
			yTween = null;
			
			// Show the close button.
			btClose.visible = true;
			
			// Stop any current audio.
			SoundMixer.stopAll();
			
			// Play the audio.
			sndFunc(aClip);
		}  // End: finishGrowing(evt:TweenEvent):void
		
		
		private function finishShrinking(evt:TweenEvent):void
		// Purpose:  Sends a message the popup is closed.
		{
			// Kills tweens.
			xTween = null;
			yTween = null;
			
			// Hide the popup.
			this.visible = false;
			
			// Send a message.
			dispatchEvent(new Event("CLOSED"));
		}  // End: finishShrinking(evt:TweenEvent):void
		
		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX         FUNCTIONS         XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		
		
		public function initPopup(snd:Function):void
		// Purpose:  Initializes the popup.
		{
			// Set the sound function.
			sndFunc = snd;
		}  // End: initPopup(snd:Function, pieces:Array):void
		
		
		public function showPopup(infoID:uint, audioID:uint):void
		// Purpose:  Shows the popup.
		{
			// Show the information.
			gotoAndStop(infoID);
			
			// Set the clip.
			aClip = audioID;
			
			// Show the popup.
			scaleX = scaleY = 0.01;
			
			this.visible = true;
			
			// Make it readable.
			xTween = new Tween(this, "scaleX", Regular.easeOut, scaleX, 1.0, 15);
			yTween = new Tween(this, "scaleY", Regular.easeOut, scaleY, 1.0, 15);
			
			xTween.addEventListener(TweenEvent.MOTION_FINISH, finishGrowing, false, 0, true);
		}  // End: showPopup(infoID:uint, audioID:uint):void
		
		
	}  // End: class
	
}  // End: package
