﻿package
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Graphics;
	
	public class ProgressBar extends MovieClip
	{
		// Declare vars here.
		private var cover:Sprite;
		private var top:Number;
		private var bot:Number;
		private var step:Number;
		private var left:Number;
		private var right:Number;
		
		//public  var mvBar:MovieClip;
		
		// Constructor.
		public function ProgressBar()
		{
			// Get the coordinates.
			top = -0.5 * mvBar.height;
			bot =  0.5 * mvBar.height;
			
			left  = -0.5 * mvBar.width;
			right =  left;
			
			// Create the mask.
			cover = new Sprite();
			
			cover.x = 0;
			cover.y = 0;
			
			// Add the mask.
			addChild(cover);
			
			// Set the mask.
			mvBar.mask = cover;
		}  // End: ProgressBar()
		
		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX     SETTERS AND GETTERS    XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

		
		public function set total(tot:uint):void
		// Purpose:  Sets the step size based on the amount represented by the bar.
		{
			step = mvBar.width / tot;
		}  // End: set total(tot:Number):void
		
		
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		// XXXX          FUNCTIONS		     XXXX
		// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		
		
		public function footstep():void
		// Purpose:  Advances the progress bar one step.
		{
			// Increase the right edge.
			right += step;
			
			drawMask();
		}  // End:step():void
		
		
		private function drawMask():void
		// Purpose:  Draws the mask.
		{
			var cnvs:Graphics = cover.graphics;
			
			// Clear the previous mask.
			cnvs.clear();
			
			// Set the fill.
			cnvs.beginFill(0x00ff00);
			
			// Draw the mask.
			cnvs.moveTo(left,  top);
			cnvs.lineTo(right, top);
			cnvs.lineTo(right, bot);
			cnvs.lineTo(left,  bot);
			cnvs.lineTo(left,  top);
			
			// End of fill.
			cnvs.endFill();
		}  // End: drawMask():void
		
		
		public function reset():void
		// Purpose:  Resets the progress bar.
		{
			cover.graphics.clear();
		}  // End: reset():void
	}  // End: class ProgressBar extends MovieClip
}  // End: package