﻿// ----------------------------------------------------------------------------------------------------------------------------------
// Last Update:	[October 28, 2009] - Paul Dinelle
// ----------------------------------------------------------------------------------------------------------------------------------

package {
	
	import flash.media.SoundMixer;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.utils.ByteArray;
	
	public class TalkingAvatar extends MovieClip {
		// Variables:
		// --------------------------------------------------------------------------------------------------------------------------
		private var threshhold_wide:Number = 11;
		private var threshhold_normal:Number = 5;
		private var threshhold_little:Number = 0.1;
		private var avatarByteArray:ByteArray = new ByteArray ();
		private var isEnabled:Boolean = true;
		private var isInitiated:Boolean = false;
		
		private static var avatarList:Array;
		
		// Constructor:
		// --------------------------------------------------------------------------------------------------------------------------
		public function TalkingAvatar () {
			this.gotoAndStop(1);
			
			if ( avatarList == null ) {
				avatarList = [];
			}
			
			checkAndAddAvatarToList( this );
			
			initiateFancyTalking();
		}
		
		
		// Functions:
		// --------------------------------------------------------------------------------------------------------------------------
		public function setThreshholds ( aWideThresh:Number, aNormalThresh:Number, aLittleThresh:Number ):void {
			// Use a value of "-1" if you want to leave the current Threshhold as-is.
			
			if ( aWideThresh >= 0 ) {
				threshhold_wide = aWideThresh;
			}
			
			if ( aNormalThresh >= 0 ) {
				threshhold_normal = aNormalThresh;
			}
			
			if ( aLittleThresh >= 0 ) {
				threshhold_little = aLittleThresh;
			}
		}
		
		public function set talkEnabled ( aBool:Boolean ):void {
			isEnabled = aBool;
			
			if ( isEnabled == false ) {
				closeMyMouth();
			}
		}
		public function get talkEnabled ():Boolean {
			return (isEnabled);
		}
		
		private function initiateFancyTalking ():void {
			if ( isInitiated ) { return; }
			
			isInitiated = true;
			isEnabled = true;
			
			closeMyMouth();
			this.addEventListener(Event.ENTER_FRAME, onAnalyzeSpectrum);
		}
		private function cleanUpFancyTalking ():void {
			if ( isInitiated == false ) { return; }
			
			isInitiated = false;
			
			this.removeEventListener(Event.ENTER_FRAME, onAnalyzeSpectrum);
			closeMyMouth();
		}
		
		private function closeMyMouth ():void {
			this.gotoAndStop("closed");
		}
		private function onAnalyzeSpectrum (evt:Event):void {
			if ( isEnabled == false ) { return; }
			
			try{
				SoundMixer.computeSpectrum(avatarByteArray, true);
				
				var tempTotal:Number = 0;
				
				for (var i:uint = 0; i < 256; i++) {
					tempTotal += avatarByteArray.readFloat();
				}
				
				if ( tempTotal >= threshhold_wide ) {
					this.gotoAndStop("wide");
				} else if ( tempTotal >= threshhold_normal ) {
					this.gotoAndStop("normal");
				} else if ( tempTotal >= threshhold_little ) {
					this.gotoAndStop("little");
				} else {
					this.gotoAndStop("closed");
				}
			} catch (e:Error) {
				
			}
		}
		
		
		// CLASS Functions:
		// --------------------------------------------------------------------------------------------------------------------------
		public static function cleanUpAll ():void {
			if ( avatarList == null ) { return; }
			if ( avatarList.length == 0 ) { return; }
			
			for (var i:int = 0; i < avatarList.length; i++) {
				if ( avatarList[i] != null ) {
					avatarList[i].cleanUpFancyTalking();
				}
			}
		}
		public static function enableAll ():void {
			if ( avatarList == null ) { return; }
			if ( avatarList.length == 0 ) { return; }
			
			for (var i:int = 0; i < avatarList.length; i++) {
				if ( avatarList[i] != null ) {
					avatarList[i].talkEnabled = true;
				}
			}
		}
		public static function enableOnly ( aClip:MovieClip ):void {
			if ( avatarList == null ) { return; }
			if ( avatarList.length == 0 ) { return; }
			
			for (var i:int = 0; i < avatarList.length; i++) {
				if ( avatarList[i] != null ) {
					if ( avatarList[i] == aClip ) {
						avatarList[i].talkEnabled = true;
					} else {
						avatarList[i].talkEnabled = false;
					}
				}
			}
		}
		
		private static function checkAndAddAvatarToList ( anAvatar:MovieClip ):void {
			for (var i:int = 0; i < avatarList.length; i++) {
				if ( avatarList[i] == anAvatar ) {
					return;
				}
			}
			
			avatarList.push( anAvatar );
		}
		
		
	}  // End: CLASS
}  // End: PACKAGE